
package kom.itbeankit.common;

/*******************************************************************************************
 * This interface defines the methods every itbean has to implement.
 *******************************************************************************************
 * <code>
 * Table Of Modifications
 *
 * 02/04/98    Kerim Mansour            Design
 * 12/05/98    Christian C. Hoffmann	following properties plus getter and setter added:
 *                                      first, last, FreeRunning, Pool
 * 20/05/98    Christian C. Hoffmann    property iterationNumber + set() and get() added
 * 22/05/98    Christian C. Hoffmann    property isConnected + set() added
 * 22/06/98    Kerim Mansour            Redesign of StandardBean and ItBean, set,getVisiblitity removed, better method names
 *                                      Design as Bean compatible to Symantec VisualCafe,
										methods accepts(int int), accepts(int) added
 * </code>
 *******************************************************************************************
 * @author Christian C. Hoffmann / Kerim Mansour
 * @version 1.21 13/07/98
 ***************************************************************************************/


/**
 *Every ItBean accepts data of a special kind.
 *We therefore define the following datatypes:
 *Multimedia:
 *1000 - 1999 text
 *2000 - 2999 audio
 *3000 - 3499 still images
 *3500 - 3999 animation (MPEG, H263,...)
 *4000 - 4999 for later use
 *Communication Networks:
 *5000 - 5999
 *5100 - 5199 Layer1
 *5400 - 5499 Layer4
 *and so on
*/
public interface StandardBean {

/**
 * This method returns the Beans beansNumber.
 * @return the bean number
 */
public int getBeanNumber();
/**
 * delivers the userlevel-see setComplexity
*/
public int getUserLevelComplexity();
/**
 * This method returns the freeRunning property that notifys wether
 * the ItBean is running step by step (restartet by startItertion())
 * or uncontrolled, running all iterations.
 * @return the freeRunning state
 */
public boolean isFreeRunning();
/**
 * This method returns the isFlag property which signalizes that
 * the itBean is the first itbean of a structure. The bean will
 * get its input data from a file or a network connection.
 * @return the first state
 */
public boolean first();
/**
 * This method retruns the last property which signalizes that
 * the itBean is the last itbean of a structure. The bean will
 * put its output data to a file or a network connection.
 * @return the state
 */
public boolean last();
/**
 * This method returns the iteration number.
 * @return int
 */

  /** This method checks wheather a certain Datatype can be
     * accepted by an ItBean (regardless of the Pin). (Comes
     * in handy if there is only one pin)
     * @see accepts (int datatype, int pin)
     */
public boolean accepts(int datatype);
/** This method is used to determine wheather the datatypes of two
     * ItBeans (that should be connected) are compatible.
     * @param datatype The Datatype of the SourceItBean
     * @param pin The Pin the SourceItBean should be connected to
     */
public boolean accepts (int datatype, int pin);

public int getIterationNumber();
/**
 * returns an array of pins for this bean
 * at the moment we expect a bean to have a maximum of
 * 20 pins ( 10 for input and 10 for output)
 * every pin is an instance of the ITBeanPin class
 * the array returned is expected to have 20 entries
 * even if most of them are null
*/
public ItBeanPin[] getPins();
/**
 * This method sets the bean number.
 * @param number int
 */
public void setBeanNumber(int number);
/**
 * This method sets the freeRunning property that notifys wether
 * the ItBean is running step by step (restartet by startItertion())
 * or uncontrolled, running all iterations.
 * @param flag the state
 */
public void setFreeRunning(boolean flag);
/**
 * This method was created by a SmartGuide.
 * @param state boolean
 */
public void setConnected(boolean state);
/**
 * This method sets the first property which signalizes that
 * the itBean is the first itbean of a structure. The bean will
 * get its input data from a file or a network connection.
 * @param flag the new state
 */
public void setFirst(boolean flag);
/**
 * This method sets the last property which signalizes that
 * the itBean is the last itbean of a structure. The bean will
 * put its output data to a file or a network connection.
 * @param flag the new state
 */
public void setLast(boolean flag);
/**
 * This method stes the iteration number that is used to
 * tell the bean which iteration it has to compute next.
 * @param newIteration the new iteration number
 */
public void setIterationNumber(int newIteration);

/** lets the ItBean run in background without graphical output
*/
public void makeVisible();

/** Makes the Bean visible (so it can show explanantions)
*/
public void makeInvisible();

public void setPins(ItBeanPin[] pins);
/**
 * This method was created by a SmartGuide.
 * @param pool DataPool
 */
public void setPool(DataPool pool);
/**
 * this method is automatically invoked
 * it should run a thread and wait for the "realstart"
 * since we modify the bean BEFORE we really start it
 * we must use two startmethods or start by an event
*/
public void start();
/**
 * This method is responsible for starting one iteration
 * If the Bean is stopped by the user it fires an ItCommunicationEvent(STOPPED)
 * If the Bean stops because there will be no more Data then
 * it fires a ItCommunicationEvent(TERMINATED)
 * for every iteration there will be a realstart() call from the framework
*/
public void startIteration();
}